/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.unix;

import com.pty4j.PtyProcess;
import com.pty4j.WinSize;
import com.pty4j.unix.Pty;
import com.pty4j.unix.UnixPtyException;
import com.pty4j.util.PtyUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001Bg\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0015\u001a\u00020\u00148\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/pty4j/unix/ProcessBuilderUnixLauncher;", "", "", "", "command", "", "environmentMap", "workingDirectory", "Lcom/pty4j/unix/Pty;", "pty", "errPty", "", "consoleMode", "", "initialColumns", "initialRows", "Lcom/pty4j/PtyProcess;", "ptyProcess", "<init>", "(Ljava/util/List;Ljava/util/Map;Ljava/lang/String;Lcom/pty4j/unix/Pty;Lcom/pty4j/unix/Pty;ZLjava/lang/Integer;Ljava/lang/Integer;Lcom/pty4j/PtyProcess;)V", "Ljava/lang/Process;", "process", "Ljava/lang/Process;", "getProcess", "()Ljava/lang/Process;", "pty4j"})
public final class ProcessBuilderUnixLauncher {
    @NotNull
    private final Process process;

    public ProcessBuilderUnixLauncher(@NotNull List<String> command, @NotNull Map<String, String> environmentMap, @NotNull String workingDirectory, @NotNull Pty pty, @Nullable Pty errPty, boolean consoleMode, @Nullable Integer initialColumns, @Nullable Integer initialRows, @NotNull PtyProcess ptyProcess) throws Exception {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter(environmentMap, (String)"environmentMap");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)pty, (String)"pty");
        Intrinsics.checkNotNullParameter((Object)ptyProcess, (String)"ptyProcess");
        File file = PtyUtil.resolveNativeFile("pty4j-unix-spawn-helper");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"resolveNativeFile(...)");
        File spawnHelper = file;
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        Object[] objectArray = new String[7];
        objectArray[0] = spawnHelper.getAbsolutePath();
        objectArray[1] = workingDirectory;
        objectArray[2] = String.valueOf(consoleMode ? 1 : 0);
        objectArray[3] = pty.getSlaveName();
        objectArray[4] = String.valueOf(pty.getMasterFD());
        Pty pty2 = errPty;
        String string = pty2 != null ? pty2.getSlaveName() : null;
        if (string == null) {
            string = "";
        }
        objectArray[5] = string;
        Pty pty3 = errPty;
        objectArray[6] = String.valueOf(pty3 != null ? pty3.getMasterFD() : -1);
        builder.command(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)command));
        Map<String, String> environment = builder.environment();
        environment.clear();
        environment.putAll(environmentMap);
        builder.directory(new File(workingDirectory));
        builder.redirectInput(ProcessBuilder.Redirect.from(new File("/dev/null")));
        builder.redirectOutput(ProcessBuilder.Redirect.DISCARD);
        if (errPty == null) {
            builder.redirectErrorStream(true);
        } else {
            builder.redirectError(ProcessBuilder.Redirect.DISCARD);
        }
        Process process = builder.start();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"start(...)");
        this.process = process;
        if (initialColumns != null || initialRows != null) {
            Integer n = initialColumns;
            Integer n2 = initialRows;
            WinSize size = new WinSize(n != null ? n : 80, n2 != null ? n2 : 25);
            for (int attempt = 0; attempt < 1000; ++attempt) {
                try {
                    pty.setWindowSize(size, ptyProcess);
                    break;
                }
                catch (UnixPtyException e) {
                    if (e.getErrno() != 25) break;
                    continue;
                }
            }
        }
    }

    @NotNull
    public final Process getProcess() {
        return this.process;
    }
}

